/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IAttribute;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.attribute.IAttributeTarget;
import dev.toma.gunsrpg.api.common.attribute.IDisplayableModifier;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AttributeSkill
extends SimpleSkill
implements IDescriptionProvider {
    private final IAttributeTarget[] targets;

    public AttributeSkill(SkillType<? extends AttributeSkill> type, IAttributeTarget ... targets) {
        super(type);
        this.targets = targets;
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        List displayableAttributes = Arrays.stream(this.targets).filter(this::isDisplayable).collect(Collectors.toList());
        int count = displayableAttributes.size();
        ITextComponent[] components = new ITextComponent[desiredLineCount + count];
        SkillUtil.Localizations.prepareEmptyDescriptionLines(this.getType(), desiredLineCount, components);
        String rawString = String.format("skill.%s.description.", ModUtils.convertToLocalization(this.getType().getRegistryName()));
        int index = desiredLineCount;
        for (IAttributeTarget target : displayableAttributes) {
            IDisplayableModifier displayableModifier = (IDisplayableModifier)((Object)target.getModifier());
            double modifierValue = target.getModifier().getModifierValue();
            int formatterValue = displayableModifier.getFormatter().formatAttributeValue(modifierValue);
            String tag = displayableModifier.getTagId();
            components[index++] = new TranslationTextComponent(rawString + tag, new Object[]{formatterValue});
        }
        return components;
    }

    @Override
    public void onPurchase(PlayerEntity player) {
        PlayerData.get(player).ifPresent(data -> {
            ISkillProvider skillProvider = data.getSkillProvider();
            AttributeSkill skill = ModUtils.firstNonnull((AttributeSkill)SkillUtil.getTopHierarchySkill(this.getType(), skillProvider), this);
            IAttributeProvider provider = data.getAttributes();
            for (IAttributeTarget target : skill.targets) {
                this.applyTarget(target, provider);
            }
        });
    }

    @Override
    public void onDeactivate(PlayerEntity player) {
        PlayerData.get(player).ifPresent(data -> {
            IAttributeProvider provider = data.getAttributes();
            for (IAttributeTarget target : this.targets) {
                IAttributeId attributeId = target.getTargetAttribute();
                IAttributeModifier modifier = target.getModifier();
                provider.getAttribute(attributeId).removeModifier(modifier);
            }
        });
    }

    private void applyTarget(IAttributeTarget target, IAttributeProvider provider) {
        IAttributeModifier modifier = target.getModifier();
        IAttributeId attributeId = target.getTargetAttribute();
        IAttribute attribute = provider.getAttribute(attributeId);
        attribute.addModifier(modifier);
    }

    private boolean isDisplayable(IAttributeTarget target) {
        return target.getModifier() instanceof IDisplayableModifier;
    }
}

